/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.tag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class TagNode<T> {
    private final List<TagNode<T>> children = new ArrayList<TagNode<T>>();

    public static <T> TagNode<T> ofValues(class_6885<T> value) {
        return new ValuesTagNode<T>(value);
    }

    public static <T> TagNode<T> ofReference(class_6862<T> key) {
        return new ReferenceTagNode<T>(key);
    }

    public List<TagNode<T>> children() {
        return this.children;
    }

    public void addChild(TagNode<T> child) {
        this.children.add(child);
    }

    public void addValuesChild(class_6885<T> child) {
        this.children.add(TagNode.ofValues(child));
    }

    public void addReferenceChild(class_6862<T> child) {
        this.children.add(TagNode.ofReference(child));
    }

    public String asTree() {
        StringBuilder builder = new StringBuilder(50);
        this.printTree(builder, "", "");
        return builder.toString();
    }

    private void printTree(StringBuilder builder, String prefix, String childrenPrefix) {
        this.asText(prefix, builder);
        Iterator<TagNode<T>> it = this.children.iterator();
        while (it.hasNext()) {
            TagNode<T> next = it.next();
            if (it.hasNext()) {
                next.printTree(builder, childrenPrefix + "\u251c\u2500\u2500 ", childrenPrefix + "\u2502   ");
                continue;
            }
            next.printTree(builder, childrenPrefix + "\u2514\u2500\u2500 ", childrenPrefix + "    ");
        }
    }

    protected abstract void asText(String var1, StringBuilder var2);

    @Nullable
    public class_6885<T> getValue() {
        return null;
    }

    @Nullable
    public class_6862<T> getReference() {
        return null;
    }

    private static class ValuesTagNode<T>
    extends TagNode<T> {
        private final class_6885<T> value;

        public ValuesTagNode(class_6885<T> value) {
            this.value = value;
        }

        @Override
        public class_6885<T> getValue() {
            return this.value;
        }

        @Override
        protected void asText(String prefix, StringBuilder builder) {
            for (class_6880 holder : this.value) {
                holder.method_40230().ifPresent(key -> {
                    builder.append(prefix);
                    builder.append(key.method_29177().toString());
                    builder.append('\n');
                });
            }
        }
    }

    private static class ReferenceTagNode<T>
    extends TagNode<T> {
        private final class_6862<T> key;

        public ReferenceTagNode(class_6862<T> key) {
            this.key = key;
        }

        @Override
        public class_6862<T> getReference() {
            return this.key;
        }

        @Override
        protected void asText(String prefix, StringBuilder builder) {
            builder.append(prefix);
            builder.append(this.key.comp_327());
            builder.append('\n');
        }
    }
}

